###############################
#  JDN
#  Uptime parser for Everquest
#  by Goladus
#
#  You will need Activeperl to run this script.  It can be downloaded for free at www.activeperl.com.  It promps you to register, however they clearly state registration is not required.
#
# This script takes an EQ log file and parses the damage of a specified character, and calculates uptime based on the following criteria:
#  
# If the previous combat message was less than or equal to X seconds ago, count as uptime.  
# Set the value for X here:

$X = 7;

# set $outt to 0 for verbose output
$outt = 1;

$filename = $ARGV[1];

if ($filename){

$charname = $ARGV[0];


open(FILE,$filename);
@dam = <FILE>;
close(FILE);

@months = qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);

if(@dam)
{
    
print "\n";

#################################################
#  The following lines construct a list called 
#  [b]@dam[/b].  This list will hold the 
#  combat data we will analyze.
#################################################

##################################################
#  The following lines weed out unwanted messages
#  If you know how to use regular expressions in
#  Perl, this is where you can tailor the 
##################################################
@dam = grep !/finishing/, @dam;  
@dam = grep !/healed/, @dam;
@dam = grep /(\] $charname .* for .+ points of damage)|(\] $charname .* for .+ points of non-melee damage)/i, @dam;

#DISABLE PREVIOUS LINE AND ENABLE FOLLOWING LINE TO OBTAIN OVERALL COMBAT RATIO
#@dam = grep / for .+ points* of damage/i, @dam;

##################################################


($month, $day, $hour, $minute, $second) = $dam[0] =~ /\[[A-Z][a-z][a-z] ([A-Z][a-z][a-z]) ([0-9]+) ([0-9][0-9]):([0-9][0-9]):([0-9][0-9]) [0-9]/;
$inseconds = ($day * 24 * 60 * 60) + ($hour * 60 * 60) + ($minute * 60) + $second;
$starttime = $inseconds;


# Variables

$tnmd = 0;
$ibf = 0; 
$hits = 0;
$resist = 0;
$highd = 0;
$lowd = 30210;
#spell list

##################
#Begin Algorithm #
##################

foreach $lin (@dam)
{

    $oldtime = $inseconds;
    ($month, $day, $hour, $minute, $second) = $lin =~ /\[[A-Z][a-z][a-z] ([A-Z][a-z][a-z]) ([0-9]+) ([0-9][0-9]):([0-9][0-9]):([0-9][0-9]) [0-9]/;
    $inseconds = ($day * 24 * 60 * 60) + ($hour * 60 * 60) + ($minute * 60) + $second;
    $totelapsed = $inseconds - $starttime;
    $elaps = $inseconds - $oldtime;
	if ($elaps > $X){
		$tnc += $elaps;}
	


    #if ($lin =~ /for .+ points/)
    #{
	($d) = $lin =~ /for (.+) points*/;
	$tnmd = $tnmd + $d;
	$hits += 1;
	if ($d > $highd) {$highd = $d;}
	if ($d < $lowd) {$lowd = $d;}
    #}
    if ($outt != 1){
	print "--- $elaps sec  $totelapsed sec--- $lin";
}
	else {}#print "$hits , $elaps , $totelapsed , $d\n";}

    
}
if (($totelapsed - $tnc) > 0){
$ticp=(($totelapsed - $tnc)/$totelapsed)*100;
$ticp=~s/(\d*\.\d{3}).*/$1/;}

print $charname;
print "\nTotal Elapsed Time: $totelapsed seconds\n";
print "Estimated time spent in combat: ", $totelapsed - $tnc, " seconds ";
if (($totelapsed - $tnc) >= 0){
	print "($ticp\%)\n";}
print "Total damage dealt: $tnmd\n";
print "Total hits: $hits\n";
if ($hits > 0){
	$adph=$tnmd/$hits;
	$adph=~s/(\d*\.\d{3}).*/$1/;
	print "Average damage per hit: ", $adph, "\n";}
print "Highest hit: $highd\n";
print "Lowest hit: $lowd\n";
print "DPS in Combat:";
if (($totelapsed - $tnc) > 0){
	print " ", ($tnmd/($totelapsed - $tnc)), "\n";}
print "DPS overall:";
if ($totelapsed > 0){
	print " ", ($tnmd/$totelapsed), "\n";}
print "Average DPH:";
if ($totelapsed > 0){
	print " ", ($tnmd/$totelapsed * 3600), "\n";}
$totalcost = 0;

######################################

}
else 
{
print "Error, the file was not found\n"
}
}
else
{
    print "\n   Usage: \n perl jdn.pl PlayerName logfile.txt \n\n";
}

sub gettime
{
($month, $day, $hour, $minute, $second) = $log[0] =~ /\[[A-Z][a-z][a-z] ([A-Z][a-z][a-z]) ([0-9]+) ([0-9][0-9]):([0-9][0-9]):([0-9][0-9]) [0-9]/;
$inseconds = ($day * 24 * 60 * 60) + ($hour * 60 * 60) + ($minute * 60) + $second;
}


